package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.application.MyApplication
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.base.adapter.BaseCartAdapter
import com.seatel.mobilehall.ui.home.activity.MyCartActivity
import com.seatel.mobilehall.ui.home.model.CartModel
import com.seatel.mobilehall.ui.home.viewholder.CartDeviceViewHolder
import com.seatel.mobilehall.ui.home.viewholder.CartScratchViewHolder
import com.seatel.mobilehall.ui.home.viewholder.CartSimViewHolder
import com.seatel.mobilehall.util.manager.OrderingManager
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.seatel.mobilehall.util.customview.ErrorHandleView

open class MyCartAdapter(context: Context?, errorHandleView: ErrorHandleView?, recyclerView: RecyclerView?, refreshLayout: SwipeRefreshLayout?)
    : BaseCartAdapter(context, errorHandleView, recyclerView, refreshLayout),
    AddOnsAdapter.MyCartAddOnClick {

    private val typeToken = object : TypeToken<ArrayList<CartModel>>() {
    }.type

    init {
        this.onGetData()
    }

    open fun onGetData() {
        onRequestData {
            if (offset == 0) {
                OrderingManager.getInstance().cartsModels.clear()
                OrderingManager.getInstance().deviceIconUrl = it.optString("deviceIcon")
                OrderingManager.getInstance().simIconUrl = it.optString("simIcon")
                OrderingManager.getInstance().simPriceIconUrl = it.optString("simPriceIcon")
                OrderingManager.getInstance().scratchCardIconUrl = it.optString("scratchCardIcon")
                OrderingManager.getInstance().topUpIconUrl = it.optString("topUpIcon")
            }
            MyApplication.badgeCartCount = it.optJSONObject("metadata").optInt("total")
            val tmpList = Gson().fromJson(it.optJSONArray("data").toString(), typeToken) as ArrayList<CartModel>
            for (data in tmpList) {
                data.isSelected = true
            }
            OrderingManager.getInstance().cartsModels.addAll(tmpList)
            OrderingManager.getInstance().updateSimPriceDiscount()
            if (OrderingManager.getInstance().orderCallback != null)
                OrderingManager.getInstance().orderCallback.onCartModify()
            if (tmpList.size < limit)
                setDone(true)
            notifyDataSetChanged()
        }
    }

    override fun getItemViewType(position: Int): Int {
        return when (OrderingManager.getInstance().cartsModels[position].type) {
            "device" -> DEVICE
            "sim-card" -> SIM
            else -> SCRATCH
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            DEVICE -> CartDeviceViewHolder(LayoutInflater.from(context).inflate(R.layout.holder_cart_device_item, parent, false))
            SIM -> CartSimViewHolder(LayoutInflater.from(context).inflate(R.layout.holder_cart_sim_item, parent, false))
            else -> CartScratchViewHolder(LayoutInflater.from(context).inflate(R.layout.holder_cart_scratch_item, parent, false))
        }
    }

    override fun getItemCount(): Int {
        return OrderingManager.getInstance().cartsModels.size
    }

    override fun getUrlRequestFunctionName(): String {
        return "carts"
    }

    override fun getRequestParams(params: HashMap<String, String>?) {
        params?.put("phoneNumber", OrderingManager.getInstance().getPhoneNumber(context as BaseActivity))
        super.getRequestParams(params)
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            is CartDeviceViewHolder -> holder.onBind(OrderingManager.getInstance().cartsModels[position])
            is CartScratchViewHolder -> holder.onBind(OrderingManager.getInstance().cartsModels[position])
            is CartSimViewHolder -> holder.onBind(OrderingManager.getInstance().cartsModels[position], this, position)
        }
        if (context is MyCartActivity)
            holder.itemView.setOnClickListener {
                rowClickNotify(position)
//                OrderingManager.getInstance().cartsModels[position].isSelected = !OrderingManager.getInstance().cartsModels[position].isSelected
//                OrderingManager.getInstance().orderCallback?.onCartModify()
//                notifyDataSetChanged()
            }
    }

    override fun rowClickNotify(position: Int) {
        OrderingManager.getInstance().cartsModels[position].isSelected = !OrderingManager.getInstance().cartsModels[position].isSelected
        OrderingManager.getInstance().updateSimPriceDiscount()
        OrderingManager.getInstance().orderCallback?.onCartModify()
        notifyDataSetChanged()
    }

    companion object {
        const val DEVICE = 0
        const val SIM = 1
        const val SCRATCH = 2
    }
}
