package com.seatel.mobilehall.data.network.retrofit

import com.seatel.mobilehall.BuildConfig
import com.seatel.mobilehall.data.network.Devices
import com.seatel.mobilehall.ui.application.MyApplication
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.TimeUnit

class RetrofitInstance {

    companion object {


        private val interceptor: HttpLoggingInterceptor =
            HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)

        private val client = OkHttpClient.Builder().readTimeout(60, TimeUnit.SECONDS)
            .connectTimeout(60, TimeUnit.SECONDS).writeTimeout(60, TimeUnit.SECONDS)
            .addInterceptor(Interceptor { chain ->
                val request = chain.request().newBuilder()
                    .addHeader("X-App-Version", Devices.getAppVersionName(MyApplication.appContext))
                    .addHeader("X-Language", "en").addHeader("X-Latitude", "")
                    .addHeader("X-Longitude", "").addHeader("X-Timestamp", "")
                    .addHeader("X-Timezone", "").addHeader("X-Platform", "Android")
                    .addHeader("X-OS-Version", "1.1.1").addHeader("X-UDID", "")
                    .addHeader("X-App-Signature", "")
                    .addHeader("Content-Type", "application/json; charset=utf-8")
                    .addHeader("x-api-key", BuildConfig.CLIENT_ID).build()
                chain.proceed(request)
            }).addInterceptor(interceptor).build()

        private val retrofit = Retrofit.Builder().baseUrl(BuildConfig.BASE_URL)
            .addConverterFactory(GsonConverterFactory.create()).client(client).build()


        val seatelApi by lazy {
            retrofit.create(API::class.java)
        }
    }
}