package com.seatel.mobilehall.ui.login.fragment

import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.MotionEvent
import android.view.View
import android.widget.EditText
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.ui.login.interactor.ForgotPasswrodVerifyCodeInteractor
import com.seatel.mobilehall.ui.login.interactor.SignUpInteractor
import com.seatel.mobilehall.ui.login.model.ResetPasswordModel
import com.seatel.mobilehall.ui.login.presenter.ConfirmSignUpPresenter
import com.seatel.mobilehall.ui.login.presenter.ForgotPasswrodVerifyCodePresenter
import com.seatel.mobilehall.ui.login.presenter.SignUpPresenter
import com.seatel.mobilehall.util.AnimationUtil
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.fragment_confirmation_forgot_pass.*

class ConfirmationForgotPassFragment : ConfirmationFragment(), SignUpInteractor.View,
    ForgotPasswrodVerifyCodeInteractor.View, View.OnTouchListener {


    private lateinit var mConfirmUserPresenter: ForgotPasswrodVerifyCodePresenter
    private lateinit var mSignUpPresenter: SignUpPresenter
    private lateinit var mConfirmCodeAddNewPhonePresenter: ConfirmSignUpPresenter
    private var mConfirmCode = ""

    override fun onRequestCodeSucceed(resetPassword: ResetPasswordModel) {
        error_view.visibility = View.GONE
        startResendCountDown()
        tv_resend_code_confirm.isEnabled = true
    }

    override fun onRequestCodeFailed(error: VolleyError) {
        isRequesting = false
        error_view.visibility = View.GONE
        SeatelAlertDialog.with(requireContext(), SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
        tv_resend_code_confirm.isEnabled = true
    }

    override fun onVerifyCodeSucceed() {
        isRequesting = false
        cancelRuningTimer()
        if (isFeatureAddNewPhone())
            getMainActivity().closeHome()
        else {
            val newPassFragment = NewPasswordFragment()
            if (TextUtils.isEmpty(mConfirmCode)) {
                mConfirmCode = text_view_hidden.text.toString().trim()
                keyboard_view.hideKeyBoard()
            }
            newPassFragment.setDataPost(getPhone(), mConfirmCode)
            getmMainFragmentPresenter()!!.addFragment(newPassFragment, true)
        }
        button_confirm.isEnabled = true
    }

    override fun onVerifyCodeFailed(error: VolleyError) {
        isRequesting = false
        error_view.visibility = View.GONE
        SeatelAlertDialog.with(requireContext(), SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
        mConfirmCode = ""
        button_confirm.isEnabled = true
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
        setFragmentLayout(R.layout.fragment_confirmation_forgot_pass)
    }

    private fun startConfirmCode() {
        if (isRequesting) return
        var codeConfirm = ""
        if (text_view_hidden != null)
            codeConfirm = text_view_hidden.text.toString().trim()
        if (TextUtils.isEmpty(codeConfirm) || codeConfirm.length < 6) {
            SeatelAlertDialog.with(requireContext(), getString(R.string.enter_confirmation)).show()
            return
        }
        isRequesting = true
        button_confirm.isEnabled = false
        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        when {
            getTypeConfirm().equals(Constant.VERRIFY_PHONE_NUMBER, true) -> {

                mConfirmCodeAddNewPhonePresenter.onConfirmCode(
                    "v2/",
                    codeConfirm,
                    "",
                    "",
                    getPhone(),
                    "",
                    "",
                    getTypeConfirm()
                )
                return
            }
            isFeatureAddNewPhone() -> {
                mConfirmCodeAddNewPhonePresenter.onConfirmCode(
                    "v2/",
                    codeConfirm,
                    "",
                    getPhone(),
                    getMainPhone(),
                    "",
                    "",
                    Constant.LINK_PHONE_NUMBER
                )
                return
            }
            else -> {
                mConfirmUserPresenter.onVerifyCode(codeConfirm, getPhone())
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        mConfirmCodeAddNewPhonePresenter.onDestroy()
        mConfirmUserPresenter.onDestroy()
    }

    override fun onTouch(v: View?, event: MotionEvent?): Boolean {
        if (v != null)
            when (v.id) {
                R.id.edit_text_confirm_code_one, R.id.edit_text_confirm_code_two, R.id.edit_text_confirm_code_three, R.id.edit_text_confirm_code_four,
                R.id.edit_text_confirm_code_five, R.id.edit_text_confirm_code_six -> {
                    onEditTextSearchTouch()
                }
            }
        return false
    }

    private fun setEditTextTouchListener(textEdit: EditText) {
        textEdit.setOnTouchListener(this)
        textEdit.showSoftInputOnFocus = false
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        mConfirmCodeAddNewPhonePresenter = ConfirmSignUpPresenter(requireContext(), this)
        mConfirmUserPresenter = ForgotPasswrodVerifyCodePresenter(requireContext(), this)
        mSignUpPresenter = SignUpPresenter(requireContext(), this)
//        getHomeActivity().setFilterSMS(SeatelUtils.checkIsNonSeatel(getPhone()))

        setEditTextTouchListener(edit_text_confirm_code_one)
        setEditTextTouchListener(edit_text_confirm_code_two)
        setEditTextTouchListener(edit_text_confirm_code_three)
        setEditTextTouchListener(edit_text_confirm_code_four)
        setEditTextTouchListener(edit_text_confirm_code_five)
        setEditTextTouchListener(edit_text_confirm_code_six)

        view_input_code.setOnClickListener {
            onEditTextSearchTouch()
        }
        button_confirm.setOnClickListener {
            AnimationUtil.instance?.collapse(layout_keyboard)
            startConfirmCode()
        }
        tv_resend_code_confirm.setOnClickListener {
            error_view.setViewMode(ErrorHandleView.Mode.LOADING)
            tv_resend_code_confirm.isEnabled = false
            resetCodeInput()
            onEditTextSearchTouch()
            when {
                getTypeConfirm().equals(Constant.VERRIFY_PHONE_NUMBER, true) -> {
                    mSignUpPresenter.onRequestCode(getPhone(), "", getTypeConfirm(), "v2/", "")
                    return@setOnClickListener
                }
                isFeatureAddNewPhone() -> {
                    mSignUpPresenter.onRequestCode(
                        getMainPhone(),
                        "",
                        getTypeConfirm(),
                        "v2/",
                        getPhone()
                    )
                    return@setOnClickListener
                }
                else -> mSignUpPresenter.onRequestCode(getPhone(), "", getTypeConfirm(), "v2/", "")
            }
        }
        image_view_back.setOnClickListener { onBackPress() }

        //Auto confirm testing
//        text_view_hidden.text = "123456"
//        startConfirmCode()
    }

    private fun onEditTextSearchTouch() {
        AnimationUtil.instance?.expand(layout_keyboard)
    }

    override fun onBackPress() {
        cancelRuningTimer()
        var forgotPass = ForgotPasswordFragment()
        if (getTypeConfirm().equals(Constant.VERRIFY_PHONE_NUMBER, true))
            forgotPass.setDataForModifyProfile(Constant.VERRIFY_PHONE_NUMBER)
        else if (isFeatureAddNewPhone())
            forgotPass.setDataForAddNewPhone(getMainPhone())
        getmMainFragmentPresenter()!!.addFragment(forgotPass, true)
    }

    override fun code(code: String) {
        mConfirmCode = code
        super.code(code)
    }


//    override fun code(code: String) {
//        super.code(code)

//        if (TextUtils.isEmpty(code)) {
//            SeatelAlertDialog.with(context, "Please input code confirmation.").show()
//            return
//        }
//        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
//        mConfirmUserPresenter.onVerifyCode(code, getPhone())
//    }


}