package com.seatel.mobilehall.ui.home.viewholder

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseRecyclerAdapter
import com.seatel.mobilehall.ui.home.model.BuySimSummaryItemModel
import com.seatel.mobilehall.util.AppUtils
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import kotlinx.android.synthetic.main.layout_buy_sim_summary_item.view.*
import kotlinx.android.synthetic.main.layout_content_special_offer_item.view.*

/**
 *
 *
 * @author Noel
 * @version
 * @created on 18-Oct-18
 */
class BuySimSummaryHolder(itemView: View) : BaseViewHolder<BuySimSummaryItemModel>(itemView) {
    override fun binData(baseRecyclerAdapter: BaseRecyclerAdapter<BuySimSummaryItemModel>) {
        val dataModel = baseRecyclerAdapter.getItem(adapterPosition)
        itemView.text_title.text = dataModel.title
        getViewByType(dataModel)
    }

    private fun getViewByType(data: BuySimSummaryItemModel) {
        itemView.layout_child_content.removeAllViews()
        when (data) {
            is BuySimSummaryItemModel.SpecialOffer -> {
                addTopSpecialOfferView(data)
            }
            is BuySimSummaryItemModel.TopUpAmount -> {
                addTopUpAmountView(data)
            }
            is BuySimSummaryItemModel.PlanSubscription -> {
                addPlanSubscriptionView(data)
            }
        }
    }

    private fun addTopSpecialOfferView(data: BuySimSummaryItemModel.SpecialOffer) {
        val view = LayoutInflater.from(itemView.context)
            .inflate(R.layout.layout_content_special_offer, itemView.layout_child_content, false)
        val mRecyclerView = view.findViewById<RecyclerView>(R.id.recycler_special_offer)
        mRecyclerView.setHasFixedSize(true)
        mRecyclerView.layoutManager = object : LinearLayoutManager(itemView.context) {
            override fun canScrollVertically(): Boolean {
                return false
            }
        }
        if (data.data != null) {
            val specialOfferAdapter = SpecialOfferAdapter(data.data!!)
            if (mRecyclerView.adapter == null) {
                mRecyclerView.adapter = specialOfferAdapter
            }
        }
        itemView.layout_child_content.addView(view)
    }

    private fun addTopUpAmountView(data: BuySimSummaryItemModel.TopUpAmount) {
        val view = LayoutInflater.from(itemView.context)
            .inflate(R.layout.layout_content_top_up_active, itemView.layout_child_content, false)
        val textAmount = view.findViewById<TextView>(R.id.text_amount)
        textAmount.text = AppUtils.decimalFormat().format(data.amount)
        itemView.layout_child_content.addView(view)
    }

    private fun addPlanSubscriptionView(data: BuySimSummaryItemModel.PlanSubscription) {
        val view = LayoutInflater.from(itemView.context).inflate(
            R.layout.layout_content_plan_subscription,
            itemView.layout_child_content,
            false
        )
        val textAmount = view.findViewById<TextView>(R.id.text_plan_name)
        val textAddOn = view.findViewById<TextView>(R.id.text_default)
        var dayStr = SeatelUtils.translatForDialog(itemView.context, "Day")

        textAmount.text = data.name
        if (data.isAddOn && data.addOnPrice > 0.0) {
            textAddOn.visibility = View.VISIBLE
            var str = "(${
                checkDayStr(
                    dayStr,
                    data.duration!!
                )
            } = ${SeatelUtils.formatDecimalNumber(data.addOnPrice, "$#.##")})"
            if (data.code == Constant.VALUE_PACK)
                str = "(${
                    SeatelUtils.formatDecimalNumber(
                        data.addOnPrice,
                        "$#.#"
                    )
                } = ${SeatelUtils.formatDecimalNumber(data.duration!!.toDouble(), "$###,###")})"

            textAddOn.text = str
        } else textAddOn.visibility = View.INVISIBLE
        val imageIcon = view.findViewById<ImageView>(R.id.image_plan_icon)
        if (data.planIcon!!.isNotEmpty())
            Glide.with(itemView.context).load(data.planIcon).into(imageIcon)
        else if (data.icon != null) {
            imageIcon.setImageResource(data.icon!!)
        }
        itemView.layout_child_content.addView(view)
    }

    private fun checkDayStr(strDay: String, dayCount: Int): String {
        return when (SeatelUtils.getLangaugeCode(itemView.context)) {
            Constant.KHMER, Constant.CHINESE -> {
                "$dayCount$strDay"
            }
            else -> {
                "$dayCount-$strDay"
            }
        }
    }

    private class SpecialOfferAdapter(mData: List<String>) : BaseRecyclerAdapter<String>(mData) {
        override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseViewHolder<String> {
            return SpecialOfferHolder(
                LayoutInflater.from(parent.context)
                    .inflate(R.layout.layout_content_special_offer_item, parent, false)
            )
        }

    }

    private class SpecialOfferHolder(itemView: View) : BaseViewHolder<String>(itemView) {
        override fun binData(baseRecyclerAdapter: BaseRecyclerAdapter<String>) {
            val data = baseRecyclerAdapter.getItem(adapterPosition)
            itemView.text_description.text = data
        }
    }
}