package com.seatel.mobilehall.ui.home.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.home.interactor.UpdatedMyOrderProcessInteractor
import com.seatel.mobilehall.util.Constant
import org.json.JSONException
import org.json.JSONObject

class UpdatedMyOrderProcessPresenter(
    private var mContext: Context,
    private var mView: UpdatedMyOrderProcessInteractor.View
) : UpdatedMyOrderProcessInteractor.Presenter {

    override fun onPutOrderProcess(orderId: String) {
        postMyOrderProcress(orderId).setOnErrorListener { error ->
            mView.onPostOrderProcessTokenFailed(error)
        }.setOnResponseListener { response ->
            mView.onPostOrderProcessSucceed(response as JSONObject)
        }.execute()
    }

    private fun postMyOrderProcress(orderId: String): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {


            override fun onGetBodyRequest(): String {
                val data = JSONObject()
                try {
                    data.put("orderServiceStatus", "delivered")
                } catch (e: JSONException) {
                    e.printStackTrace()
                }

                return data.toString()
            }

            override fun getFunctionName(): String {
                return Constant.ORDERS + "/$orderId"
            }

            override fun getMethod(): Int {
                return Request.Method.PUT
            }

        }
    }
}