package com.seatel.mobilehall.data.network

import com.seatel.mobilehall.util.Resource
import retrofit2.Response

abstract class BaseApiResponse {

    suspend fun <T> safeApiCall(apiCall: suspend () -> Response<T>): Resource<T> {
        try {
            val response = apiCall()
            if (response.isSuccessful) {
                val body = response.body()
                body?.let {
                    return Resource.Success(body)
                }

            }
            return error("${response.code()} ${response.message()}")
        } catch (e: Exception) {
            return error(e.message ?: e.toString())
        }

    }

    private fun <T> error(errorMessage: String): Resource<T> =
        Resource.Error("Api Call Failed $errorMessage")


}