package com.seatel.mobilehall.util

import android.os.Bundle
import com.google.firebase.analytics.ktx.analytics
import com.google.firebase.ktx.Firebase

object AnalyticsHelper {

    private val TAG = AnalyticsHelper::class.java.simpleName

    private val firebaseAnalytics = Firebase.analytics

    object Event {
        //HomeTab
        const val HOME_TAP_PROFILE = "home_tap_profile"
        const val HOME_TAP_INVITE_FRIEND = "home_tap_invite friend"
        const val HOME_TAP_CART = "home_tap_cart"
        const val HOME_TAP_NOTIFICATION = "home_tap_notification"
        const val HOME_TAP_PLAN = "home_tap_plan"
        const val HOME_TAP_TOP_UP = "home_tap_top_up"
        const val HOME_TAP_POINT = "home_tap_point"
        const val HOME_TAP_PROMOTION = "home_tap_promotion"
        const val HOME_TAP_YES_HUB = "home_tap_yes_hub"
        const val HOME_TAP_SUPPORT = "home_tap_support"
        const val HOME_TAP_BUY_TOP_UP_CART = "home_tap_buy_top_up_card"
        const val HOME_TAP_BUY_YES_NUMBER = "home_tap_buy_yes_number"

        //Package
        const val PACKAGE_TAP_LOY_KOB = "package_tap_loy_kob"
        const val PACKAGE_TAP_FORTUNE_PACK = "package_tap_fortune_pack"
        const val PACKAGE_TAP_VIP_FORTUNE_PLAN = "package_tap_VlP_fortune_plan"
        const val PACKAGE_TAP_INTERNATION_CALL = "package_tap_international call"
        const val PACKAGE_TAP_ONE_PLAN = "package_tap_one_plan"
        const val PACKAGE_TAP = "package_tap_"

        //usage
        const val USAGE_TAP = "usage_tap_"
        const val USAGE_TAP_INTERNET = "usage_tap_internet"
        const val USAGE_TAP_VOICE = "usage_tap_voice"
        const val USAGE_TAP_SMS = "usage_taP_sms"
        const val USAGE_TAP_FILTER_DATE_INTERNET = "usage_taP_filter_date_internet"
        const val USAGE_TAP_FILTER_DATE_VOICE = "usage_taP_filter_date_voice"
        const val USAGE_TAP_FILTER_DATE_SMS = "usage_taP_filter_date_sms"
        const val USAGE_TAP_DOWNLOAD_DOCUMENT_INTERNET = "usage_taP_download_document_internet"
        const val USAGE_TAP_DOWNLOAD_DOCUMENT_VOICE = "usage_taP_download_document_voice"
        const val USAGE_TAP_DOWNLOAD_DOCUMENT_SMS = "usage_taP_download_document_sms"

        //Profile
        const val PROFILE_TAP_SETTING = "profile_tap_setting"
        const val PROFILE_TAP_PROFILE_PICTURE = "profile_tap_profile_picture"
        const val PROFILE_TAP_CHANGE_NUMBER = "profile_tap_change_number"

        //Setting
        const val SETTING_TAP_LANGUAGE = "setting_tap_language"
        const val SETTING_TAP_CHANGE_NOTIFICATION = "setting_tap_change_notification"
        const val SETTING_TAP_ENABLE_FACE_ID = "setting_tap_enable_face_id"
        const val SETTING_TAP_DISABLE_FACE_ID = "setting_tap_disable_face_id"
        const val SETTING_TAP_CLEAR_CACHE = "setting_tap_clear_cache"
        const val SETTING_TAP_APP_VERSION = "setting_tap_app_version"
        const val SETTING_TAP_USER_LOGOUT = "user_logout"

        //Language
        const val CHOOSE_KHMER_LANGUAGE = "choose_khmer_language"
        const val CHOOSE_KHMER_ENGLISH = "choose_khmer_english"
        const val CHOOSE_KHMER_CHINESE = "choose_khmer_chinese"

    }

    fun logEvent(name: String, params: Bundle?) {
        firebaseAnalytics.logEvent(name, null)
    }


}