package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityFaqDetailBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.adapter.RelatedQuestionListAdapter
import com.seatel.mobilehall.ui.home.interactor.FAQDetailInteractor
import com.seatel.mobilehall.ui.home.model.FAQModel
import com.seatel.mobilehall.ui.home.presenter.FAQDetailPresenter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.customview.ErrorHandleView

class FaqDetailActivity : BaseActivity<ActivityFaqDetailBinding>(), FAQDetailInteractor.View {


    var presenter: FAQDetailPresenter? = null
    override fun getViewBinding(): ActivityFaqDetailBinding {
        return ActivityFaqDetailBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //  setContentView(R.layout.activity_faq_detail)
        activityEnterRightAnimation()

        presenter = FAQDetailPresenter(this)
        presenter!!.loadData(getQuestionId())
        showProgress()

    }

    override fun responseSucceedFAQDetailData(answer: String) {
        hideProgress()
        binding.txtQuestion.text = getQuestion()
        binding.txtAnswer.text = answer
    }

    override fun responseSucceedGetRelatedQuestion(relatedQuestionList: List<FAQModel>) {

        binding.txtRelated.visibility = View.VISIBLE
        binding.rvRelatedQuestion.layoutManager = LinearLayoutManager(this)
        binding.rvRelatedQuestion.adapter = RelatedQuestionListAdapter(this, relatedQuestionList)
    }

    override fun responseFailedFAQDetail(error: VolleyError) {
        hideProgress()
        binding.errorView.visibility = View.VISIBLE
        when (error) {
            is NoConnectionError -> {
                binding.errorView.errorMessage = getString(R.string.connection_timeout)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }

            is TimeoutError -> {
                binding.errorView.errorMessage = getString(R.string.fetch_supported_device_data)
                binding.errorView.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }

            else -> {
                binding.errorView.errorMessage = SeatelSuperRequest.getErrorMessageFrom(error)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }
    }


    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()


    }

    fun getQuestion(): String {
        return intent.getStringExtra(Constant.EXTRA_QUESTION).toString()
    }

    fun getQuestionId(): String {
        return intent.getStringExtra(Constant.EXTRA_FAQ_ID).toString()
    }

    override fun isDisplayToolbar(): Boolean {
        return true
    }

    override fun getToolbarTitle(): String {
        return getString(R.string.faqs)
    }

    companion object {
        fun lunch(context: Context, faqId: String, question: String) {
            val intent = Intent(context, FaqDetailActivity::class.java)
            intent.putExtra(Constant.EXTRA_FAQ_ID, faqId)
            intent.putExtra(Constant.EXTRA_QUESTION, question)
            context.startActivity(intent)
        }
    }
}
