package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.graphics.Typeface
import android.os.Build
import android.text.Html
import android.text.method.LinkMovementMethod
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.databinding.ItemTermsAndServiceFooterBinding
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel


/**
 * Created by mac on 8/27/2018 AD.
 */
class TermAndServiceFooter2Adapter(
    private val mContext: Context,
    private var mTermAndServiceList: ValuePackSectionModel,
    private val mIsHTMLStyle: Boolean
) : RecyclerView.Adapter<RecyclerView.ViewHolder?>() {

//    private var mTermAndServiceList: List<String>? = null

    companion object {
        private const val HEADER = 0
        private const val FOOTER = 1
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            HEADER -> {
                val binding = ItemTermsAndServiceFooterBinding.inflate(
                    LayoutInflater.from(parent.context), parent, false
                )
                HeaderHolder(binding)
            }


            FOOTER -> {
                val binding = ItemTermsAndServiceFooterBinding.inflate(
                    LayoutInflater.from(parent.context), parent, false
                )
                FooterHolder(binding)
            }

            else -> {
                val binding = ItemTermsAndServiceFooterBinding.inflate(
                    LayoutInflater.from(parent.context), parent, false
                )
                TitleHolder(binding)
            }
        }
    }

    override fun getItemCount(): Int {
        return 3
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }


    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder.itemViewType) {
            HEADER -> {
                val text = mTermAndServiceList.valuePackSecThreeModel.description2
                val customTextView: TextView = holder.itemView as TextView
                if (mIsHTMLStyle) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        customTextView.text = Html.fromHtml(text, Html.FROM_HTML_MODE_COMPACT)
                        customTextView.movementMethod = LinkMovementMethod.getInstance()
                    } else {
                        customTextView.text = Html.fromHtml(text)
                        customTextView.movementMethod = LinkMovementMethod.getInstance()
                    }
                } else customTextView.text = text


            }

            FOOTER -> {

                val customTextView: TextView = holder.itemView as TextView
                customTextView.setTypeface(customTextView.typeface, Typeface.BOLD)
                if (mTermAndServiceList.valuePackSecTwoModel.addon.size > 0)
                    customTextView.text = "Add-on Terms & Conditions"


            }

            else -> {
                val text = mTermAndServiceList.valuePackSecThreeModel.description
                val customTextView: TextView = holder.itemView as TextView

                if (mIsHTMLStyle) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        customTextView.text = Html.fromHtml(text, Html.FROM_HTML_MODE_COMPACT)
                        customTextView.movementMethod = LinkMovementMethod.getInstance()
                    } else {
                        customTextView.text = Html.fromHtml(text)
                        customTextView.movementMethod = LinkMovementMethod.getInstance()
                    }
                } else customTextView.text = text
            }
        }
    }


    class HeaderHolder(var itemView: ItemTermsAndServiceFooterBinding) :
        RecyclerView.ViewHolder(itemView.root)

    class TitleHolder(var itemView: ItemTermsAndServiceFooterBinding) :
        RecyclerView.ViewHolder(itemView.root)

    class FooterHolder(var itemView: ItemTermsAndServiceFooterBinding) :
        RecyclerView.ViewHolder(itemView.root)


}