package com.seatel.mobilehall.ui.home.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.home.interactor.ProductServiceDetailInteractor
import com.seatel.mobilehall.ui.home.model.*
import com.seatel.mobilehall.util.lang.LanguageManager
import org.json.JSONObject

class ProductServiceDetailPrsenter(
    private var mContext: Context, private var view: ProductServiceDetailInteractor.View
) : ProductServiceDetailInteractor.Presenter {

    //  private var view = mContext as ProductServiceDetailInteractor.View
    private var lang: String? = "en"


    override fun onProServiceDetail(planCode: String,phoneNumber: String) {
        if (LanguageManager.getInstance(mContext).getLanguageCode() != null) lang =
            LanguageManager.getInstance(mContext).getLanguageCode()
        onProServiceDetailRequest(planCode,phoneNumber).setOnErrorListener { error ->
            view.onProServiceDetailFailed(error)
        }.setOnResponseListener { response ->
            view.onProServiceDetailSucceed(prepareValuePackDetailModel(response as JSONObject))
        }.execute()
    }


    private fun prepareValuePackDetailModel(response: JSONObject): ValuePackSectionModel {

        val dataPackSection = ValuePackSectionModel()
        dataPackSection.type = response.optString("type")
        dataPackSection.name = response.optString("name")
        val dataPackSectionOneModel = OnePlanDetailSecOneModel()
        dataPackSectionOneModel.mobileImageUrl =
            response.optJSONObject("section1").optString("mobileImageUrl")
        dataPackSectionOneModel.imageUrl = response.optJSONObject("section1").optString("imageUrl")
        dataPackSection.dataPackDetailSecOneModel = dataPackSectionOneModel

        val dataPackSecTwoModel = ValuePackSecTwoModel()
        dataPackSecTwoModel.title = response.optJSONObject("section2").optString("title")
        dataPackSecTwoModel.subTitle = response.optJSONObject("section2").optString("subTitle")
        val featureList = response.optJSONObject("section2").optJSONArray("featureList")
        val features = ArrayList<String>()
        (0 until featureList.length()).mapTo(features) { featureList.optString(it) }
        dataPackSecTwoModel.featureList = features
        dataPackSection.valuePackSecTwoModel = dataPackSecTwoModel

        val table = response.optJSONObject("section2").optJSONArray("table")
        val tableList = ArrayList<ValuePackTableModel>()
        for (i in 0 until table.length()) {

            val dataPackTableModel = ValuePackTableModel()

            val data = table.optJSONObject(i).optJSONArray("data")
            val fee = table.optJSONObject(i).optJSONArray("fee")
            val validate = table.optJSONObject(i).optJSONArray("validity")
            val activation = table.optJSONObject(i).optJSONArray("activation")
            val benefitOffer = table.optJSONObject(i).optString("benefitOffer")

            if (table.optJSONObject(i).optJSONArray("callsms") != null && !table.optJSONObject(i)
                    .optString("code").isNullOrBlank()
            ) {
                val callsms = table.optJSONObject(i).optJSONArray("callsms")
                val callSmsList = ArrayList<String>()
                (0 until callsms.length()).mapTo(callSmsList) { callsms.optString(it) }
                val code = table.optJSONObject(i).optString("code")
                dataPackTableModel.callsmsList = callSmsList
                dataPackTableModel.code = code
            }

            dataPackTableModel.valuePrice = fee.optString(0)
            dataPackTableModel.priceChange = data.optString(0)
            dataPackTableModel.validityDate = validate.optString(0)
            dataPackTableModel.activation = activation.optString(0)
            dataPackTableModel.benefitOffer = benefitOffer


            tableList.add(dataPackTableModel)
        }

        dataPackSecTwoModel.table = tableList


        //add-on
        val addon = response.optJSONObject("section2").optJSONArray("addOn")
        val addonList = ArrayList<ValuePackTableModel>()
        if (addon != null) {
            for (i in 0 until addon.length()) {
                val dataPackTableModel = ValuePackTableModel()

                val data = addon.optJSONObject(i).optJSONArray("data")
                val fee = addon.optJSONObject(i).optJSONArray("fee")
                val validate = addon.optJSONObject(i).optJSONArray("validity")
                val activation = addon.optJSONObject(i).optJSONArray("activation")
                val activateBtn = addon.optJSONObject(i).optBoolean("activateBtn")

                if (addon.optJSONObject(i)
                        .optJSONArray("callsms") != null && !addon.optJSONObject(i)
                        .optString("code").isNullOrBlank()
                ) {
                    val callsms = addon.optJSONObject(i).optJSONArray("callsms")
                    val callSmsList = ArrayList<String>()
                    (0 until callsms.length()).mapTo(callSmsList) { callsms.optString(it) }
                    val code = addon.optJSONObject(i).optString("code")

                    dataPackTableModel.callsmsList = callSmsList
                    dataPackTableModel.code = code

                }



                dataPackTableModel.valuePrice = fee.optString(0)
                dataPackTableModel.priceChange = data.optString(0)
                dataPackTableModel.validityDate = validate.optString(0)
                dataPackTableModel.activation = activation.optString(0)
                dataPackTableModel.activateBtn = activateBtn
                addonList.add(dataPackTableModel)
            }
        }


        dataPackSecTwoModel.addon = addonList

        dataPackSection.valuePackSecTwoModel = dataPackSecTwoModel

        val section3 = response.optJSONObject("section3")
        if (section3 != null) {
            val dataPackThreeModel = DataPackSecThreeModel()
            dataPackThreeModel.description =
                response.optJSONObject("section3").optString("description")

            dataPackThreeModel.description2 =
                response.optJSONObject("section3").optString("description2")
            dataPackSection.valuePackSecThreeModel = dataPackThreeModel
        }



        return dataPackSection
    }

    private fun onProServiceDetailRequest(planCode: String,phoneNumber:String): SeatelJSONObjectRequest {
        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return "v2/products/$planCode?lang=$lang&phoneNumber=$phoneNumber"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }


        }
    }
}