package com.seatel.mobilehall.ui.home.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.seatel.mobilehall.R;
import com.seatel.mobilehall.ui.home.activity.PaymentActivity;
import com.seatel.mobilehall.ui.home.model.PaymentMethodModel;

import java.util.ArrayList;
import java.util.List;

public class PaymentsAdapter extends RecyclerView.Adapter<PaymentsAdapter.MyViewHolder> {

    private final Context mContext;
    private List<PaymentMethodModel> mPaymentMethod = new ArrayList<>();

    public PaymentsAdapter(Context context) {
        this.mContext = context;
    }

    public void setDataMethod(List<PaymentMethodModel> paymentMethod) {
        this.mPaymentMethod = paymentMethod;
        notifyDataSetChanged();
    }

    public class MyViewHolder extends RecyclerView.ViewHolder {
        private final ImageView imageView;
        private final TextView title;
        private final TextView description;

        private final Button promotion;
        //  private final ImageView imageViewBig;
        private final View mainView;

        public MyViewHolder(View view) {
            super(view);
            imageView = view.findViewById(R.id.img_method);
            title = view.findViewById(R.id.bankTitle);
            description = view.findViewById(R.id.bankDescription);
            //  imageViewBig = view.findViewById(R.id.img_method_big);
            promotion = view.findViewById(R.id.btn_top_up_promotion);
            mainView = view.findViewById(R.id.view_main);
        }

    }

    @Override
    public void onViewAttachedToWindow(@NonNull MyViewHolder holder) {
        holder.imageView.requestFocus();
        super.onViewAttachedToWindow(holder);
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int position) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_method_payment, parent, false);
        return new MyViewHolder(itemView);
    }


    @Override
    public void onBindViewHolder(@NonNull final MyViewHolder holder, final int position) {
        final PaymentMethodModel data = mPaymentMethod.get(position);

        Glide.with(mContext).load(data.getPaymentIcon()).into(holder.imageView);
        holder.description.setText(data.getDescription());
        holder.title.setText(data.getTitle());

        if (data.getDiscountRate() > 0) holder.promotion.setVisibility(View.VISIBLE);
        holder.promotion.setText(data.getDiscountName());


     /*   holder.imageViewBig.setVisibility(View.GONE);
        holder.imageView.setVisibility(View.GONE);
        if (TextUtils.equals(data.getPaymentName(), "aba")) {
         //   holder.imageViewBig.setVisibility(View.VISIBLE);
          //  Glide.with(mContext).load(data.getPaymentIcon()).into(holder.imageViewBig);
        } else {
            holder.imageView.setVisibility(View.VISIBLE);
            Glide.with(mContext).load(data.getPaymentIcon()).into(holder.imageView);
        }
        holder.mainView.setVisibility(View.GONE);  */
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                holder.mainView.setVisibility(View.VISIBLE);
                ((PaymentActivity) mContext).showPaymentDetail(data.getPaymentName(), position);
            }
        });
    }

    @Override
    public int getItemCount() {
        return mPaymentMethod.size();
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }
}
