package com.seatel.mobilehall.ui.invite_friend

import android.Manifest
import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import android.widget.Toast
import com.android.volley.Request
import com.bumptech.glide.Glide
import com.google.gson.Gson
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityInviteFriendBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.model.InviteFriendModel
import com.seatel.mobilehall.util.BottomInviteFriendDialog
import com.seatel.mobilehall.util.PermissionUtil
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.customview.ErrorHandleView
import org.json.JSONObject

class InviteFriendActivity : BaseActivity<ActivityInviteFriendBinding>() {


    companion object {
        fun launchForResult(context: Context) {
            val intent = Intent(context, InviteFriendActivity::class.java)
            context.startActivity(intent)
        }
    }

    private var mPhotoRequest: PermissionUtil.PermissionRequestObject? = null
    private var mDataFriendList: ArrayList<BottomInviteFriendDialog.BottomInviteFriendModel>? =
        null

    override fun getViewBinding(): ActivityInviteFriendBinding {
        return ActivityInviteFriendBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //    setContentView(R.layout.activity_invite_friend)
        binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        getQrCode()
        mDataFriendList = ArrayList()
        binding.btnScanQr.setOnClickListener {
            showPermissionCamera()
        }

        binding.btnMyQr.setOnClickListener {
            InviteFriendQrcodeActivity.launch(this)
        }

        binding.totalFriend.setOnClickListener {
            if (mDataFriendList != null && mDataFriendList?.size!! > 0) {
                BottomInviteFriendDialog(this).addFriendNumber(mDataFriendList!!).show()
            }
        }

    }


    private fun getQrCode() {

        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/referal-qrcode/${getPhoneLogin()}"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }.setOnErrorListener {
            SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(it))
                .show()
            binding.errorView.visibility = View.GONE
        }.execute {
            val response = it as JSONObject
            val inviteFriend = InviteFriendModel()
            val data = Gson().fromJson(response.toString(), inviteFriend::class.java)

            if (data.listReferrer.isNotEmpty() && !data.listReferrer.isNullOrEmpty()) {
                mDataFriendList =
                    java.util.ArrayList()
                for (i in 0 until data.listReferrer.size) {

                    var mLastTopup: String = ""
                    mLastTopup = if (data.listReferrer[i].lastTopup.isNullOrBlank()) {
                        ""
                    } else {
                        data.listReferrer[i].lastTopup
                    }

                    mDataFriendList?.add(
                        BottomInviteFriendDialog.BottomInviteFriendModel(
                            data.listReferrer[i].refereeNbr,
                            SeatelUtils.getDateTime(
                                "yyyy-MM-dd", "dd MMM YYYY",
                                data.listReferrer[i].createdAt
                            ),
                            SeatelUtils.getDateTime(
                                "yyyy-MM-dd", "dd MMM YYYY",
                                mLastTopup
                            )

                        )
                    )


                }
            }

            if (data.count > 0)
                binding.totalFriendInvitation.text = data.count.toString()
            else
                binding.totalFriendInvitation.text = "0"
            if (data.link.isNotEmpty())
                Glide.with(this).load(data.link).into(binding.ivQr)
            if (data.scan) {
                binding.btnScanQr.visibility = View.VISIBLE
            } else
                binding.btnScanQr.visibility = View.GONE
            if (data.qr) {
                binding.btnMyQr.visibility = View.VISIBLE
            } else
                binding.btnMyQr.visibility = View.GONE

            if (data.message.isNotEmpty()) {
                binding.tvMessage.visibility = View.VISIBLE
                binding.tvMessage.text = data.message
            }
            binding.errorView.visibility = View.GONE
        }

    }

    private fun showPermissionCamera() {
        mPhotoRequest = PermissionUtil.with(this).request(Manifest.permission.CAMERA)
            .onAllGranted(object : PermissionUtil.Func() {
                override fun call() {
                    InviteFriendScanQrActivity.launchForResult(
                        this@InviteFriendActivity
                    )
                }

            }).onAnyDenied(object : PermissionUtil.Func() {
                override fun call() {
                    Toast.makeText(
                        this@InviteFriendActivity,
                        "Camera permission is needed to open camera.",
                        Toast.LENGTH_LONG
                    ).show()
                }
            }).askPermission(999)
    }

    override fun getToolbarTitle(): String {
        return "Invite Friend"
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }

}