package com.seatel.mobilehall.data.prefs

import android.content.Context
import android.content.SharedPreferences
import android.graphics.Bitmap

class ProfileSharedPreference(context: Context) {

    private var sharedPref: SharedPreferences? = null

    init {
        this.sharedPref = context.getSharedPreferences("SeatelPreferences", Context.MODE_PRIVATE)
    }

    companion object {
        @Volatile
        private var instance: ProfileSharedPreference? = null

        fun getInstance(context: Context): ProfileSharedPreference? {
            if (instance == null)  // NOT thread safe!
                instance = ProfileSharedPreference(context)
            return instance
        }
    }

    fun getDocumentType(): String? {
        return sharedPref?.getString("DOCUMENT_TYPE", "")
    }

    fun setDocumentType(documentType: String?) {
        sharedPref?.edit()?.putString("DOCUMENT_TYPE", documentType)?.apply()
    }

    fun getId(): String? {
        return sharedPref?.getString("ID", "")
    }

    fun setId(id: String?) {
        sharedPref?.edit()?.putString("ID", id)?.apply()
    }

    fun getName(): String? {
        return sharedPref?.getString("NAME", "")
    }

    fun setName(name: String?) {
        sharedPref?.edit()?.putString("NAME", name)?.apply()
    }

    fun getGender(): String? {
        return sharedPref?.getString("GENDER", "")
    }

    fun setGender(gender: String?) {
        sharedPref?.edit()?.putString("GENDER", gender)?.apply()
    }

    fun getDay(): String? {
        return sharedPref?.getString("DAY", "")
    }

    fun setDay(day: String?) {
        sharedPref?.edit()?.putString("DAY", day)?.apply()
    }

    fun getMonth(): String? {
        return sharedPref?.getString("MONTH", "")
    }

    fun setMonth(month: String?) {
        sharedPref?.edit()?.putString("MONTH", month)?.apply()
    }

    fun getYear(): String? {
        return sharedPref?.getString("YEAR", "")
    }

    fun setYear(year: String?) {
        sharedPref?.edit()?.putString("YEAR", year)?.apply()
    }

    fun getDob(): String? {
        return sharedPref?.getString("DOB", "")
    }

    fun setDob(dob: String?) {
        sharedPref?.edit()?.putString("DOB", dob)?.apply()
    }


    fun setFrontId(fontId: String?) {
        sharedPref?.edit()?.putString("FONTID", fontId)?.apply()
    }

    fun getFrontId(): String? {
        return sharedPref?.getString("FONTID", "")
    }

    fun setBackId(backId: String?) {
        sharedPref?.edit()?.putString("BACKID", backId)?.apply()
    }

    fun getBackId(): String? {
        return sharedPref?.getString("BACKID", "")
    }

    fun setProfileImage(profileImage: String?) {
        sharedPref?.edit()?.putString("PROFILE", profileImage)?.apply()
    }

    fun getProfileImage(): String? {
        return sharedPref?.getString("PROFILE", "")
    }
}