package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.animation.AnimationUtils
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.model.AppProductsResponseModel

class ProductServiceHomeAdapter(
    private var mContext: Context,
    private var productsList: ArrayList<AppProductsResponseModel>,
    private var rowClick: (index: AppProductsResponseModel) -> Unit
) : BaseAdapter<ProductServiceHomeAdapter.ProductServiceViewHolder>() {

    private var limit = 6

    class ProductServiceViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var mIcon = itemView.findViewById<ImageView>(R.id.ivIcon)
        var mTitle = itemView.findViewById<TextView>(R.id.tvTitle)
        var btnSubscribe = itemView.findViewById<Button>(R.id.btnSubscribe)
        var layout_main = itemView.findViewById<ConstraintLayout>(R.id.layout_main)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ProductServiceViewHolder {
        return ProductServiceViewHolder(
            LayoutInflater.from(mContext).inflate(R.layout.item_product_service, parent, false)
        )
    }

    override fun onBindViewHolder(holder: ProductServiceViewHolder, position: Int) {
        holder.itemView.visibility = View.INVISIBLE
        setMyAnimation(
            holder.itemView,
            position,
            AnimationUtils.loadAnimation(mContext, R.anim.anim_recycler_item_horizontal)
        )
        holder.mTitle.text = productsList[position].name
        Glide.with(mContext).load(productsList[position].icon).into(holder.mIcon)
        holder.layout_main.setOnClickListener {
            productsList[position].let(rowClick)
        }
    }

    override fun getItemCount(): Int {
        return if (productsList.size > limit) {
            limit
        } else
            productsList.size
    }
}