package com.seatel.mobilehall.ui.yes_member.adapter

import android.content.Context
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ItemTopPartnerSearchBinding
import com.seatel.mobilehall.ui.yes_member.model.PartnerModelItem

class TopPartnerSearchAdapter(
    private var mContext: Context, private var partnerSearchList: ArrayList<PartnerModelItem>
) : RecyclerView.Adapter<TopPartnerSearchAdapter.ViewHolder>() {


    class ViewHolder(var binding: ItemTopPartnerSearchBinding) :
        RecyclerView.ViewHolder(binding.root) {
        fun bind(mContext: Context, partnerModelItem: PartnerModelItem) {


            Glide.with(mContext).load(partnerModelItem.icon)
                .placeholder(R.drawable.ic_yes_profile).dontAnimate().into(binding.ivIcon)

            binding.tvPartnerName.text = partnerModelItem.name
        }
    }

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): TopPartnerSearchAdapter.ViewHolder {
        val binding = ItemTopPartnerSearchBinding.inflate(
            android.view.LayoutInflater.from(parent.context), parent, false
        )
        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: TopPartnerSearchAdapter.ViewHolder, position: Int) {
        holder.bind(mContext, partnerSearchList[position])
    }

    override fun getItemCount(): Int {
        return partnerSearchList.size
    }
}