package com.seatel.mobilehall.ui.home.model

import com.google.gson.annotations.SerializedName

class YesNumberModel(@SerializedName("number") var phoneNumber: String?,
                     @SerializedName("price") var price: Double,
                     @SerializedName("cardPrice") var cardPrice: Double,
                     @SerializedName("skipTopUp") var skipTopUp: Boolean,
                     @SerializedName("discountedPrice") var discountedPrice: Double,
                     @SerializedName("discountRate") var discountRate: Double) {
    var isChecked = false

    override fun equals(other: Any?): Boolean {
        if (other != null && other is YesNumberModel) {
            return other.phoneNumber.equals(this.phoneNumber, true)
        }
        return false
    }

    override fun hashCode(): Int {
        var result = phoneNumber?.hashCode() ?: 0
        result = 31 * result + price.hashCode()
        result = 31 * result + isChecked.hashCode()
        return result
    }
}