package com.seatel.mobilehall.util;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;

/**
 * Created by mac on 11/14/2018 AD.
 */

public class ScanMRZSharePref {

    private static final String SCAN_SHARED_PREFS = "ScanMRZ";
    private final SharedPreferences sharedPrefs;
    private static ScanMRZSharePref mAppShareConstant;
    private Context mContext = null;

    private ScanMRZSharePref(Context context) {
        mContext = context;
        this.sharedPrefs = context.getSharedPreferences(SCAN_SHARED_PREFS, Activity.MODE_PRIVATE);
    }

    public synchronized static ScanMRZSharePref getConstant(Context context) {
        if (null == mAppShareConstant) {
            mAppShareConstant = new ScanMRZSharePref(context);
        }
        return mAppShareConstant;
    }

    public void setScanMrzKey(String key) {
        sharedPrefs.edit().putString("SCAN_MRZ_KEY", key.trim()).apply();
    }

    public String getScanMrzKey() {
        return sharedPrefs.getString("SCAN_MRZ_KEY", "");
    }

}
