package com.seatel.mobilehall.ui.yes_member.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.databinding.ItemPartnerCategoryListBinding
import com.seatel.mobilehall.ui.yes_member.model.PartnerModelItem

class PartnerCategoryListAdapter(
    private var mContext: Context,
    private var partnerModelItem: ArrayList<PartnerModelItem>
) : RecyclerView.Adapter<PartnerCategoryListAdapter.ViewHolder>() {

    class ViewHolder(var binding: ItemPartnerCategoryListBinding) :
        RecyclerView.ViewHolder(binding.root) {
        fun bind(context: Context, partnerModelItem: PartnerModelItem) {

            Glide.with(context).load(partnerModelItem.icon).into(binding.ivIcon)

            binding.tvPartnerName.text = partnerModelItem.name
            binding.tvPartnerOutlet.text = partnerModelItem.totalOutlet.toString() + " Outlet"
            binding.btnDiscount.text = partnerModelItem.discountDesc

        }
    }


    override fun onCreateViewHolder(
        parent: ViewGroup, viewType: Int
    ): ViewHolder {
        val binding = ItemPartnerCategoryListBinding.inflate(
            LayoutInflater.from(parent.context), parent, false
        )
        return ViewHolder(binding)
    }

    override fun getItemCount(): Int {
        return partnerModelItem.size
    }

    override fun onBindViewHolder(holder: PartnerCategoryListAdapter.ViewHolder, position: Int) {
        val data = partnerModelItem[position]
        holder.bind(mContext, data)

    }
}