package com.seatel.mobilehall.ui.profile.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.profile.interactor.ScanMRZInteractor
import com.seatel.mobilehall.util.Constant
import org.json.JSONObject

class ScanMRZPresenter(private var mContext: Context) : ScanMRZInteractor.Presenter {

    private var mView = mContext as ScanMRZInteractor.View

    override fun onRequestMRZKey() {

        getScanMRZCodeRequest().setOnErrorListener { error ->
            mView.onGetMRZKeyFailed(error)
        }.setOnResponseListener { response ->
            mView.onGetMRZKeySucceed((response as JSONObject).optString("key"))
        }.execute()
    }

    private fun getScanMRZCodeRequest(): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return Constant.SCAN_MZR
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }
    }

}