package com.seatel.mobilehall.ui.game

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import android.view.View.OnClickListener
import com.android.volley.Request
import com.google.gson.Gson
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityCholchoungBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.dialogannouncement.CustomGameDialog
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import org.json.JSONObject

class GameActivity : BaseActivity<ActivityCholchoungBinding>(), OnClickListener {

    private var mChance: Int = 0
    private var mTitle: String = ""
    private var mPrize: String = ""
    private var mSubTitle: String = ""
    private var mImage: String = ""
    
    override fun getViewBinding(): ActivityCholchoungBinding {
        return ActivityCholchoungBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(binding.root)
        init()
    }


    private fun init() {
        binding.imageViewBack.setOnClickListener(this)
        binding.buttonPlay.setOnClickListener(this)
        binding.tvGetPrice.setOnClickListener(this)
    }


    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, GameActivity::class.java)
            context.startActivity(intent)
        }

    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.button_play -> {
                binding.cholChoungAnim.playAnimation()
                requestChance()
            }

            R.id.tv_get_price -> {
                GameRewardActivity.launch(this)
            }

            R.id.imageViewBack -> onBackPressed()
        }
    }


    private fun requestChance() {
        //  error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/get-chance/${getPhoneLogin()}/chaol-chhoung"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }.setOnErrorListener {
            binding.cholChoungAnim.cancelAnimation()
            //   error_view.visibility = View.GONE
            SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(it)).show()

        }.execute {
            //  error_view.visibility = View.GONE
            mChance = (it as JSONObject).optInt("chance")
            if (mChance > 0) {
                CoroutineScope(Dispatchers.Main).launch {
                    delay(1000) // 1000 milliseconds = 1 second
                    randomGame()
                }
            } else {
                binding.cholChoungAnim.pauseAnimation()
                SeatelAlertDialog.with(
                    this, applicationContext.getString(R.string.game_no_chance)
                ).show()
            }
        }

    }

    private fun randomGame() {
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/get-angpao/${getPhoneLogin()}/chaol-chhoung"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }.setOnErrorListener {
            binding.cholChoungAnim.cancelAnimation()
            SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(it)).show()

        }.execute {
            binding.cholChoungAnim.cancelAnimation()
            val data = it as JSONObject
            Log.d("TAG::>>>", "randomGame: ${Gson().toJson(data)} ")

            mTitle = data.optString("title")
            mPrize = data.optString("prize")
            mSubTitle = data.optString("subtitle")
            mImage = data.optString("image")

            val valentineDialog =
                CustomGameDialog(this, mTitle, mPrize, mSubTitle, mImage, true, false)
            valentineDialog.show()

        }
    }

}

