package com.seatel.mobilehall.ui.yes_member

import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.yes_member.adapter.PartnerCategoryAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.TopPartnerInteractor
import com.seatel.mobilehall.ui.yes_member.model.PartnerCategoryModelItem
import com.seatel.mobilehall.ui.yes_member.model.TopPartnerModelItem
import com.seatel.mobilehall.ui.yes_member.presenter.TopPartnerPresenter

class YesMemberFragment : Fragment(), TopPartnerInteractor.View {

    private lateinit var recyclerPartner: RecyclerView
    private lateinit var recyclerPartnerCategory: RecyclerView
    private lateinit var adapter: YesMemberAdapter
    private lateinit var partnerCategoryAdapter: PartnerCategoryAdapter

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        TopPartnerPresenter(requireContext(), this).onTopPartnerData()
        TopPartnerPresenter(requireContext(), this).onPartnerCategory()
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        val view = inflater.inflate(R.layout.fragment_yes_member, container, false)

        recyclerPartner = view.findViewById(R.id.RecyclerPartner)
        recyclerPartnerCategory = view.findViewById(R.id.RecyclerPartnerCategory)



        return view
    }

    override fun responseTopPartnerSucceed(topPartnerList: ArrayList<TopPartnerModelItem>) {
        Log.d("TAG::>>>", "responseTopPartnerSucceed: $topPartnerList")
        recyclerPartner.layoutManager =
            LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false)
        adapter = YesMemberAdapter(requireContext(), topPartnerList)
        recyclerPartner.adapter = adapter
    }

    override fun responseTopPartnerFail(error: VolleyError) {
        Log.d("TAG::>>>", "responseTopPartnerFail: ${error.message}")
    }

    override fun responsePartnerCategorySucceed(partnerCategory: ArrayList<PartnerCategoryModelItem>) {
        recyclerPartnerCategory.layoutManager = GridLayoutManager(context, 2)
        partnerCategoryAdapter = PartnerCategoryAdapter(requireContext(), partnerCategory)
        recyclerPartnerCategory.adapter = partnerCategoryAdapter
    }

    override fun responsePartnerCategoryFail(error: VolleyError) {
        Log.d("TAG::>>>", "responsePartnerCategoryFail: ${error.message}")
    }


}